# Image-to-EEG Generation using Diffusion Models

This project implements a brain-computer interface (BCI) system that generates EEG signals from images using diffusion models and CLIP embeddings. The system explores various cross-modal fusion strategies to improve the mapping between visual stimuli and corresponding brain responses.

## Project Overview

The goal of this project is to generate EEG signals that correspond to given images using deep learning techniques. It leverages the power of diffusion models for signal generation and CLIP embeddings for image representation, with different cross-modal fusion strategies to connect these modalities.

## Key Features

- **Diffusion-based EEG Generation**: Uses diffusion models to generate realistic EEG signals from image embeddings
- **Multiple Fusion Strategies**: Implements and compares various cross-modal fusion methods:
  - Cross-attention mechanism (primary approach)
  - Concatenation-based fusion
  - Addition-based fusion
- **Cross-subject Analysis**: Tests model generalization across different subjects

## Project Structure

```
.
├── clipper.py                  # CLIP model wrapper for image embedding extraction
├── data.py                     # Data loading and preprocessing utilities
├── experiments.py              # Supplementary experiments including cross-subject evaluation
├── model.py                    # Main model with cross-attention fusion
├── model_add.py                # Model variant with addition-based fusion
├── model_concat.py             # Model variant with concatenation-based fusion
├── plot_topography_comparison.py # Visualization of EEG topography comparisons
├── train.py                    # Training script for main model
├── train_ablation.py           # Training script for ablation study models
└── utils.py                    # Utility functions for training and evaluation
```

## Models

### Main Model (Cross-Attention Fusion)
The primary model uses a UNet-based diffusion architecture with cross-attention mechanisms to fuse image embeddings (from CLIP) with EEG generation process.

### Ablation Study Models
1. **Concatenation Fusion**: Concatenates image embeddings with EEG features
2. **Addition Fusion**: Adds image embeddings to EEG features

## Data

The system expects preprocessed EEG data and corresponding image embeddings. The data loader supports:
- EEG data with multiple trials that are averaged
- Image data processed through CLIP embeddings
- Subject-specific data organization

## Training

### Main Model Training
```bash
python train.py --data_path /path/to/data --subject 1 --epochs 100
```

### Ablation Study Training
```bash
python train_ablation.py --data_path /path/to/data --subject 1 --model_type concat --epochs 50
```

### Supplementary Experiments
```bash
python experiments.py --data_path /path/to/data --model_path /path/to/models --run_cross_subject
```

## Requirements

- Python 3.7+
- PyTorch 1.9+
- HuggingFace Diffusers
- CLIP
- Accelerate
- NumPy
- SciPy
- Scikit-learn
- Matplotlib
- Seaborn
